<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStatusesTable extends Migration {

	public function up()
	{
		Schema::create('statuses', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id')->unsigned();
			$table->string('name')->nullable();
			$table->enum('step', array('to_do', 'in_progress', 'done'));
			$table->timestamps();
			$table->softDeletes();
			$table->integer('sort');
		});
	}

	public function down()
	{
		Schema::drop('statuses');
	}
}