<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userInfo()
    {
        return $this->hasOne('UserInfo', 'user_id');
    }

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function ticket()
    {
        return $this->hasMany('Request', 'user_id');
    }

}