<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Teachers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->foreign('Cohort_id')->references('id')->on('Cohorts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Grade_Boundaries', function(Blueprint $table) {
			$table->foreign('Test_id')->references('id')->on('Tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Results', function(Blueprint $table) {
			$table->foreign('Test_id')->references('id')->on('Tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->foreign('Cohort_id')->references('id')->on('Cohorts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->foreign('Acadmic_year_id')->references('id')->on('AcademicYears')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group_Student', function(Blueprint $table) {
			$table->foreign('Class_id')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Tests', function(Blueprint $table) {
			$table->foreign('Season_id')->references('id')->on('Seasons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('Roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Cohorts', function(Blueprint $table) {
			$table->foreign('calendaryear_id')->references('id')->on('calendaryears')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Cohorts', function(Blueprint $table) {
			$table->foreign('Acadmicyear_id')->references('id')->on('AcademicYears')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group_Test', function(Blueprint $table) {
			$table->foreign('Group_id')->references('id')->on('Groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Group_Test', function(Blueprint $table) {
			$table->foreign('Test_id')->references('id')->on('Tests')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('responsibilities', function(Blueprint $table) {
			$table->foreign('faculty_id')->references('id')->on('Faculties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('responsibilities', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('Teachers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Teachers', function(Blueprint $table) {
			$table->dropForeign('Teachers_user_id_foreign');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->dropForeign('Students_user_id_foreign');
		});
		Schema::table('Students', function(Blueprint $table) {
			$table->dropForeign('Students_Cohort_id_foreign');
		});
		Schema::table('Grade_Boundaries', function(Blueprint $table) {
			$table->dropForeign('Grade_Boundaries_Test_id_foreign');
		});
		Schema::table('Results', function(Blueprint $table) {
			$table->dropForeign('Results_Test_id_foreign');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->dropForeign('Groups_Cohort_id_foreign');
		});
		Schema::table('Groups', function(Blueprint $table) {
			$table->dropForeign('Groups_Acadmic_year_id_foreign');
		});
		Schema::table('Group_Student', function(Blueprint $table) {
			$table->dropForeign('Group_Student_Class_id_foreign');
		});
		Schema::table('Tests', function(Blueprint $table) {
			$table->dropForeign('Tests_Season_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('Cohorts', function(Blueprint $table) {
			$table->dropForeign('Cohorts_calendaryear_id_foreign');
		});
		Schema::table('Cohorts', function(Blueprint $table) {
			$table->dropForeign('Cohorts_Acadmicyear_id_foreign');
		});
		Schema::table('Group_Test', function(Blueprint $table) {
			$table->dropForeign('Group_Test_Group_id_foreign');
		});
		Schema::table('Group_Test', function(Blueprint $table) {
			$table->dropForeign('Group_Test_Test_id_foreign');
		});
		Schema::table('responsibilities', function(Blueprint $table) {
			$table->dropForeign('responsibilities_faculty_id_foreign');
		});
		Schema::table('responsibilities', function(Blueprint $table) {
			$table->dropForeign('responsibilities_teacher_id_foreign');
		});
	}
}