<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function features()
	{
		return $this->belongsToMany('App\Models\Feature');
	}

	public function teams()
	{
		return $this->belongsToMany('App\Models\Team');
	}

	public function setting()
	{
		return $this->belongsTo('App\Models\Setting');
	}

}