<?php

namespace app/models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customer';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function rate()
	{
		return $this->hasMany('Offerratio', 'customer_id');
	}

	public function offerview()
	{
		return $this->hasMany('Offer');
	}

	public function offerview()
	{
		return $this->hasMany('Offerview');
	}

}