<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('description', 250);
			$table->integer('timeOfstart');
			$table->timestamps();
			$table->boolean('isActive');
			$table->string('originalprice');
			$table->double('discount_percent');
			$table->decimal('discount_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}