<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 250);
			$table->string('email');
			$table->bigInteger('role_id')->unsigned()->nullable();
			$table->string('whatsapp')->nullable();
			$table->string('phone')->nullable();
			$table->string('facebook')->nullable();
			$table->tinyInteger('type');
			$table->text('description')->nullable();
			$table->integer('views')->default('0');
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}