<?php

namespace App;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('district_id', 'name', 'email', 'phone', 'api_token');
	protected $hidden = array('password');

	public function contacts()
	{
		return $this->morphMany('App\Contact');
	}

	public function orders()
	{
		return $this->hasMany('App\Order');
	}

	public function restaurants()
	{
		return $this->belongsToMany('App\Restaurant');
	}

	public function notifications()
	{
		return $this->morphMany('App\Notification');
	}

	public function tokens()
	{
		return $this->morphMany('App\Token');
	}

	public function district()
	{
		return $this->belongsTo('App\District');
	}

}