<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 50);
			$table->string('slug', 255)->unique();
			$table->string('resource', 20)->default('System');
			$table->tinyInteger('system')->default('0');
			$table->smallInteger('rank')->unsigned()->nullable();
			$table->integer('module_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}