<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePapersTable extends Migration {

	public function up()
	{
		Schema::create('papers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('language_id')->unsigned();
			$table->integer('paper_type_id')->unsigned();
			$table->integer('task_id')->unsigned();
			$table->enum('env', array('Online', 'Phone'));
			$table->boolean('automatic')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('papers');
	}
}