<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Productos extends Model 
{

    protected $table = 'productos';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('id_ofertas');

    public function id_categorias()
    {
        return $this->hasOne('Categorias', 'id_categorias');
    }

    public function id_marcas()
    {
        return $this->hasOne('Marcas', 'id_marcas');
    }

    public function id_ofertas()
    {
        return $this->hasOne('Ofertas', 'id_ofertas');
    }

}