<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReportsTable extends Migration {

	public function up()
	{
		Schema::create('reports', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('contract_id')->unsigned();
			$table->date('date');
			$table->string('vm_name');
			$table->float('fs_used_GB');
			$table->float('fs_total_GB');
			$table->float('cpu_util_idle');
			$table->float('cpu_util_used');
			$table->float('mem_avail_GB');
			$table->float('mem_total_GB');
		});
	}

	public function down()
	{
		Schema::drop('reports');
	}
}