<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHostsTable extends Migration {

	public function up()
	{
		Schema::create('hosts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamp_from');
			$table->timestamp('timestamp_to');
			$table->boolean('active');
			$table->string('name')->index();
			$table->integer('pool_id')->unsigned();
			$table->integer('datacenter_id')->unsigned();
			$table->bigInteger('memory_free');
			$table->string('cpu_model_name');
			$table->integer('cpu_nr');
			$table->float('cpu_speed', 4,3);
			$table->text('SR');
			$table->bigInteger('memory_total');
			$table->boolean('host_is_master');
			$table->ipAddress('ip_address');
			$table->string('uuid', 36);
		});
	}

	public function down()
	{
		Schema::drop('hosts');
	}
}