<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVirtualhostsTable extends Migration {

	public function up()
	{
		Schema::create('virtualhosts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamp('timestamp_from');
			$table->timestamp('timestamp_to');
			$table->boolean('active');
			$table->integer('vm_id')->unsigned();
			$table->integer('agency_id')->unsigned();
			$table->string('erlog');
			$table->string('redir');
			$table->boolean('ssl');
			$table->ipAddress('ip');
			$table->string('file');
			$table->string('vm_name');
			$table->string('aclog');
			$table->string('sn');
			$table->string('cms');
		});
	}

	public function down()
	{
		Schema::drop('virtualhosts');
	}
}