<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Entree_stock extends Eloquent {

	protected $table = 'entrees_stock';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('quantite', 'id_prix', 'id_fournisseur', 'id_user', 'montant');
	protected $visible = array('quantite', 'id_prix', 'id_fournisseur', 'id_user', 'montant');

	public function fournisseur()
	{
		return $this->belongsTo('App\Models\Fournisseur', 'id_fournisseur');
	}

	public function prix()
	{
		return $this->belongsTo('App\Models\Prix', 'id_prix');
	}

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

}