<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Parent extends Eloquent {

	protected $table = 'parents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'mobile', 'email', 'national_id', 'address', 'job', 'gender', 'date_birth', 'password');
	protected $hidden = array('password');

	public function students()
	{
		return $this->hasMany('App\Models\Student');
	}

}