<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTemplateLayerTable extends Migration {

	public function up()
	{
		Schema::create('template_layer', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('text', 'image'));
			$table->integer('order');
			$table->string('position_x');
			$table->string('position_y');
			$table->string('width');
			$table->string('height');
			$table->integer('template_id');
			$table->integer('layer_text_id');
			$table->integer('layer_image_id');
		});
	}

	public function down()
	{
		Schema::drop('template_layer');
	}
}