<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->timestamps();
			$table->string('file_path');
			$table->string('name');
			$table->text('description');
			$table->enum('format', array('image', 'video', 'binary'));
			$table->integer('downloads_count');
			$table->timestamp('available_until');
			$table->integer('project_id');
			$table->integer('catalog_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}