<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Studentwork extends Eloquent {

	protected $table = 'studentworks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('homework_id', 'user_id', 'time_spent', 'work_date', 'right_percentage', 'counter', 'percentage_counter', 'status');

	public function homeWork()
	{
		return $this->belongsTo('Homework');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}