<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('role_id', 'name', 'fist_name', 'username', 'email');

    public function role()
    {
        return $this->hasOne('Role');
    }

    public function exercises()
    {
        return $this->hasMany('Exercise');
    }

    public function groups()
    {
        return $this->belongsToMany('Group');
    }

    public function studentWorks()
    {
        return $this->hasMany('Studentwork');
    }

    public function institutions()
    {
        return $this->belongsToMany('Institution');
    }

    public function links()
    {
        return $this->hasMany('Link');
    }

}