<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Exercise extends Model 
{

    protected $table = 'exercises';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('theme_id', 'type_id', 'user_id', 'name', 'source', 'statement');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function theme()
    {
        return $this->hasOne('Theme');
    }

    public function homeworks()
    {
        return $this->belongsToMany('Homework');
    }

    public function medias()
    {
        return $this->belongsToMany('Media');
    }

}