<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiltersTable extends Migration {

	public function up()
	{
		Schema::create('filters', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('sdk_key');
			$table->smallInteger('index', true);
			$table->string('image');
			$table->string('background_image')->nullable();
			$table->string('highlight_image')->nullable();
			$table->boolean('is_active');
			$table->bigInteger('category_id')->unsigned()->index();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('filters');
	}
}