<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('porteurs', function(Blueprint $table) {
			$table->foreign('ville_id')->references('id')->on('villes')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('investisseurs', function(Blueprint $table) {
			$table->foreign('Category_Investisseur_id')->references('id')->on('categories_investisseurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('porteur_id')->references('id')->on('porteurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->foreign('Category_Projet_id')->references('id')->on('categories_projets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('investisseur_id')->references('id')->on('investisseurs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('projet_id')->references('id')->on('projets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('porteurs', function(Blueprint $table) {
			$table->dropForeign('porteurs_ville_id_foreign');
		});
		Schema::table('investisseurs', function(Blueprint $table) {
			$table->dropForeign('investisseurs_Category_Investisseur_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_porteur_id_foreign');
		});
		Schema::table('projets', function(Blueprint $table) {
			$table->dropForeign('projets_Category_Projet_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_investisseur_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_projet_id_foreign');
		});
	}
}