<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePorteursTable extends Migration {

	public function up()
	{
		Schema::create('porteurs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fullname', 100);
			$table->date('date_naissance');
			$table->text('adresse');
			$table->string('email', 100);
			$table->string('phone', 30);
			$table->string('diplome', 50)->nullable();
			$table->string('user_name', 50)->unique();
			$table->string('password', 50);
			$table->integer('ville_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('porteurs');
	}
}