<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('Reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->integer('product_id')->unsigned();
			$table->integer('rating');
			$table->text('comment');
			$table->boolean('approved');
			$table->boolean('spam');
			$table->bigInteger('close');
		});
	}

	public function down()
	{
		Schema::drop('Reviews');
	}
}