<?php

namespace App\Models\GestionContrat;

class Contrat extends Eloquent {

	protected $table = 'contrats';
	public $timestamps = true;
	protected $fillable = array('partenaire_id', 'date_demarrage', 'date_fin', 'montant');

	public function contrat()
	{
		return $this->belongsTo('App\Models\GestionPartenaire\Partenaire');
	}

	public function services()
	{
		return $this->belongsToMany('App\Models\GestionContrat\Service', 'contrat_id');
	}

}