<?php

namespace Traders;

use Illuminate\Database\Eloquent\Model;

class Trader extends Model 
{

    protected $table = 'traders';
    public $timestamps = true;

    public function depositOperation()
    {
        return $this->hasMany('DepositOperation', 'trader_id');
    }

    public function purchasing()
    {
        return $this->hasMany('Purchasing', 'purchasing');
    }

    public function sectoralSelling()
    {
        return $this->hasMany('SectoralSelling', 'trader_id');
    }

    public function wholesale()
    {
        return $this->hasMany('Wholesale', 'trader_id');
    }

}