<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Purchasing', function(Blueprint $table) {
			$table->foreign('trader_id')->references('id')->on('traders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Wholesale', function(Blueprint $table) {
			$table->foreign('trader_id')->references('id')->on('traders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Wholesale', function(Blueprint $table) {
			$table->foreign('goods_type_id')->references('id')->on('GoodsType')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('SectoralSelling', function(Blueprint $table) {
			$table->foreign('trader_id')->references('id')->on('traders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Purchasing', function(Blueprint $table) {
			$table->dropForeign('Purchasing_trader_id_foreign');
		});
		Schema::table('Wholesale', function(Blueprint $table) {
			$table->dropForeign('Wholesale_trader_id_foreign');
		});
		Schema::table('Wholesale', function(Blueprint $table) {
			$table->dropForeign('Wholesale_goods_type_id_foreign');
		});
		Schema::table('SectoralSelling', function(Blueprint $table) {
			$table->dropForeign('SectoralSelling_trader_id_foreign');
		});
	}
}