<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name');
			$table->string('last_name', 255);
			$table->string('username', 25);
			$table->string('password');
			$table->string('e-mail', 255);
			$table->string('image_pathname')->nullable();
			$table->boolean('is_admin')->default(false);
			$table->text('bio');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}