<?php

namespace App;

class DonationRequest extends Eloquent {

	protected $table = 'donation_requests';
	public $timestamps = true;
	protected $fillable = array('name', 'age', 'phone', 'hospital_name', 'amount', 'hospital_address', 'notes', 'latitude', 'longitude', 'blood_type_id');

	public function client()
	{
		return $this->belongsTo('App\Client');
	}

	public function notification()
	{
		return $this->hasOne('App\Client', 'donation_request_id');
	}

}