<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesOptionsTable extends Migration {

	public function up()
	{
		Schema::create('companies_options', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->integer('application_id')->unsigned()->nullable();
			$table->string('name', 255);
			$table->text('value')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies_options');
	}
}