<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActorScopeTable extends Migration {

	public function up()
	{
		Schema::create('actor_scope', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('actor_id')->unsigned();
			$table->integer('scopable_id')->unsigned()->index();
			$table->string('scopable_type', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('actor_scope');
	}
}