<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vouchers extends Model 
{

    protected $table = 'vouchers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'type_id', 'discount', 'start_date', 'end_date', 'entity_id', 'status');

    public function voucher()
    {
        return $this->hasOne('\VoucherType', 'voucher_type');
    }

    public function Entities()
    {
        return $this->hasOne('\Entities', 'entity_id');
    }

}