<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'description', 'status', 'p_cat_id', 'uuid');

    public function products()
    {
        return $this->hasOne('\ProductCategories', 'p_cat_id');
    }

}