<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class City extends Model 
{

    protected $table = 'city';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'state_id', 'country_id', 'uuid');

    public function country()
    {
        return $this->hasOne('\Country', 'country_id');
    }

    public function state()
    {
        return $this->hasOne('\City', 'state_id');
    }

}