<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id');
			$table->string('name_en');
			$table->string('name_ar');
			$table->string('body_en')->nullable();
			$table->string('body_ar')->nullable();
			$table->string('excerpt_en')->nullable();
			$table->string('excerpt_ar');
			$table->string('price');
			$table->string('offer_price');
			$table->timestamps();
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}