<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name_en');
			$table->string('name_ar');
			$table->tinyInteger('activation')->default('1');
			$table->boolean('is_featured')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}