<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('password');
			$table->string('image');
			$table->string('contact_phone')->unique();
			$table->string('contact_whats_app')->unique();
			$table->boolean('status')->default(0);
			$table->float('minimum_charge');
			$table->float('delivery_fee');
			$table->integer('region_id')->unsigned();
			$table->boolean('is_active')->default(0);
			$table->string('api_token', 60)->unique()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}