<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Intervention extends Eloquent {

	protected $table = 'interventions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function intervenant()
	{
		return $this->belongsTo('Organisation');
	}

	public function requests()
	{
		return $this->belongsToMany('Request')->withPivot('intervention_request');
	}

}