<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PlanOrderCards extends Model 
{

    protected $table = 'plan_order_cards';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function PlanOrder()
    {
        return $this->hasOne('PlanOrders', 'id');
    }

    public function Stage()
    {
        return $this->hasOne('Stage', 'id');
    }

    public function User()
    {
        return $this->hasOne('User', 'username');
    }

}