<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Subject extends Model 
{

    protected $table = 'subjects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('school_id', 'name', 'description', 'active');
    protected $visible = array('school_id', 'name');

    public function school()
    {
        return $this->belongsTo('App\School');
    }

    public function groupSubjectTeacher()
    {
        return $this->hasMany('App\GroupSubjectTeacher');
    }

}