<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParentsTable extends Migration {

	public function up()
	{
		Schema::create('parents', function(Blueprint $table) {
			$table->increments('id');
			$table->text('father_name')->nullable();
			$table->text('mother_name')->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->text('password');
			$table->string('contact_no', 15)->nullable()->index();
			$table->enum('type', array('mother', 'father'))->nullable();
			$table->tinyInteger('active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('parents');
	}
}