<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('newsid');
			$table->string('tittle', 256);
			$table->string('description', 256);
			$table->string('body', 256);
			$table->string('image', 256);
			$table->string('video', 256);
			$table->boolean('public');
			$table->datetime('created');
			$table->enum('category', array(''));
			$table->integer('staffid')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}