<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100);
			$table->string('email', 50)->unique();
			$table->integer('national_id')->unique();
			$table->string('password', 100);
			$table->tinyInteger('is_active')->default('1');
			$table->date('email_verified_at')->nullable();
			$table->string('phone', 25)->unique();
			$table->integer('salary')->nullable()->default('11');
			$table->date('date_of_birth')->nullable();
			$table->integer('monthly_outlay')->nullable();
			$table->integer('available_funding')->nullable();
			$table->tinyInteger('status')->default('0');
			$table->integer('language_id');
			$table->tinyInteger('notification_status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}