<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageTable extends Migration {

	public function up()
	{
		Schema::create('package', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->integer('duration')->nullable();
			$table->bigInteger('quota')->nullable();
			$table->float('price')->nullable();
			$table->integer('status')->nullable()->default('1');
			$table->integer('user_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('package');
	}
}