<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityUsersActivationsLogsTable extends Migration {

	public function up()
	{
		Schema::create('entity_users_activations_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('entity_user_id')->unsigned()->nullable();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->datetime('start_date')->nullable();
			$table->datetime('end_date')->nullable();
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_users_activations_logs');
	}
}