<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityActivationsTable extends Migration {

	public function up()
	{
		Schema::create('entity_activations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('payment_transaction_id')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->bigInteger('purchased_activation_count')->nullable();
			$table->bigInteger('purchased_month_count')->nullable();
			$table->float('activation_price')->nullable();
			$table->integer('activation_id')->unsigned()->nullable();
			$table->bigInteger('availabe_activation')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->timestamp('start_date')->nullable();
			$table->integer('status')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_activations');
	}
}