<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchActivationsTable extends Migration {

	public function up()
	{
		Schema::create('branch_activations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('branch_id')->unsigned()->nullable();
			$table->bigInteger('purchased_activation_count')->nullable();
			$table->bigInteger('purchased_month_count')->nullable();
			$table->bigInteger('availabe_activation')->nullable();
			$table->datetime('end_date')->nullable();
			$table->datetime('start_date')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('branch_activations');
	}
}