<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAttachmentTable extends Migration {

	public function up()
	{
		Schema::create('attachment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('attachment_type')->nullable();
			$table->integer('attachment_id')->unsigned()->nullable();
			$table->string('url', 255)->nullable();
			$table->string('file_name', 255)->nullable();
			$table->integer('type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('attachment');
	}
}