<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdditionsLogsTable extends Migration {

	public function up()
	{
		Schema::create('additions_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('addition_id')->unsigned()->nullable();
			$table->bigInteger('quota')->nullable();
			$table->float('price')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('additions_logs');
	}
}